import { Platform, StyleSheet } from "react-native";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

export const writeReviewStyle = StyleSheet.create({
    imgRatingCon: {
        flexDirection: "row",
        alignItems: "center",
        paddingBottom: dpr(20),
        borderBottomWidth: 1,
        borderColor: "#DFDFDF",
    },
    imgCon: {
        height: dpr(75),
        width: dpr(75),
        backgroundColor: "#F3F3F3",
        borderRadius: 4,
        alignItems: "center",
        justifyContent: "center",
    },
    productImg: {
        height: dpr(45),
        width: dpr(45),
    },
    productName: {
        color: "#2c2c2c",
        marginLeft: dpr(14),
        marginRight: dpr(14),
        fontSize: dpr(15),
        fontFamily: "DMSans_500Medium",
        lineHeight: dpr(22),
        width: dpr("wf") - dpr(20) * 2 - dpr(75),
        textAlign: 'left'
    },
    ratingCon: {
        flexDirection: "row",
        marginTop: dpr(4),
        marginLeft: dpr(14),
    },
    ratingCount: {
        marginLeft: dpr(10),
        fontSize: dpr(13),
        color: "#898989",
    },
    addRatingsCon: {
        marginTop: dpr(20),
    },
    addRatingText: {
        color: "#2c2c2c",
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        marginBottom: dpr(20),
    },
    addRatingCon: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
    },
    uploadPhotos: {
        height: dpr(130) + 3,
        backgroundColor: "#F3F3F3",
        borderStyle: "dashed",
        borderColor: "#898989",
        borderWidth: 1,
        borderRadius: 8,
        alignItems: "center",
        justifyContent: "center",
    },
    uploadText: {
        marginTop: dpr(16),
        fontSize: dpr(14),
        color: "#898989",
        fontFamily: "Roboto_500Medium",
        lineHeight: 16,
    },
    textInputStyle: {
        backgroundColor: "#F3F3F3",
        color: "#2c2c2c",
        color: "#898989",
        borderRadius: 4,
        textAlignVertical: "top",
        padding: 10,
        minHeight: Platform.OS === 'ios' ? dpr(130) : 0,
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    ratingText: {
        fontSize: dpr(18),
        color: "#898989",
        fontFamily: "Roboto_500Medium",
    },
    remainingChar: {
        color: "#898989",
        fontSize: dpr(11),
        marginTop: dpr(4),
        textAlign: "right",
    },
    submitReview: {
        backgroundColor: "#ffffff",
    },
    submitReviewCon: {
        backgroundColor: "#FCCA19",
        marginHorizontal: dpr(20),
        marginVertical: dpr(20),
        borderRadius: dpr(6),
    },
    bg: (enableUpdate) => ({
        backgroundColor: enableUpdate ? "#FCCA19" : "#F3F3F3",
    }),
    color: (enableUpdate) => ({
        color: enableUpdate ? "#2c2c2c" : "#898989",
    }),
    submitReviewText: {
        textAlign: "center",
        color: "#2c2c2c",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(18),
        paddingVertical: dpr(17),
    },
    starStyle: { marginRight: dpr(22) },
});
